import { View, Text, Dimensions, Pressable } from "react-native";
import React from "react";
import { homeStyle } from "../../../../screens/Home/homeStyle";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
import SearchIcon from "../../../../assets/svgs/searchIcon.svg";
import useLangTranslation from "../../../../hooks/useLangTranslation";
import CustomSVG from "../../CustomSVG/CustomSVG";
const { height } = Dimensions.get("screen");

const SearchInput = ({ props }) => {
    const { trans } = useLangTranslation();
    return (
        <Pressable
            style={homeStyle.searchContainer}
            onPress={() => props.navigation.navigate("filter home")}
        >
            <Text
                style={[
                    homeStyle.searchTextField,
                    homeStyle.searchTextFieldColor(height)
                ]}
            >
                {trans("Search")}
            </Text>
            <View style={homeStyle.searchIcon}>
                <CustomSVG svgIcon={SearchIcon} width={dpr(16)} height={dpr(16)} />
            </View>
        </Pressable>
    );
};

export default SearchInput;
